/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.EmptyVisitor;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;

public class BCELifier
extends EmptyVisitor {
    private static final String BASE_PACKAGE = Const.class.getPackage().getName();
    private static final String CONSTANT_PREFIX = Const.class.getSimpleName() + ".";
    private final JavaClass _clazz;
    private final PrintWriter _out;
    private final ConstantPoolGen _cp;

    public BCELifier(JavaClass javaClass, OutputStream outputStream) {
        this._clazz = javaClass;
        this._out = new PrintWriter(outputStream);
        this._cp = new ConstantPoolGen(this._clazz.getConstantPool());
    }

    public void start() {
        this.visitJavaClass(this._clazz);
        this._out.flush();
    }

    @Override
    public void visitJavaClass(JavaClass javaClass) {
        String string = javaClass.getClassName();
        String string2 = javaClass.getSuperclassName();
        String string3 = javaClass.getPackageName();
        String string4 = Utility.printArray(javaClass.getInterfaceNames(), false, true);
        if (!"".equals(string3)) {
            string = string.substring(string3.length() + 1);
            this._out.println("package " + string3 + ";");
            this._out.println();
        }
        this._out.println("import " + BASE_PACKAGE + ".generic.*;");
        this._out.println("import " + BASE_PACKAGE + ".classfile.*;");
        this._out.println("import " + BASE_PACKAGE + ".*;");
        this._out.println("import java.io.*;");
        this._out.println();
        this._out.println("public class " + string + "Creator {");
        this._out.println("  private InstructionFactory _factory;");
        this._out.println("  private ConstantPoolGen    _cp;");
        this._out.println("  private ClassGen           _cg;");
        this._out.println();
        this._out.println("  public " + string + "Creator() {");
        this._out.println("    _cg = new ClassGen(\"" + ("".equals(string3) ? string : string3 + "." + string) + "\", \"" + string2 + "\", \"" + javaClass.getSourceFileName() + "\", " + BCELifier.printFlags(javaClass.getAccessFlags(), FLAGS.CLASS) + ", new String[] { " + string4 + " });");
        this._out.println();
        this._out.println("    _cp = _cg.getConstantPool();");
        this._out.println("    _factory = new InstructionFactory(_cg, _cp);");
        this._out.println("  }");
        this._out.println();
        this.printCreate();
        Field[] fieldArray = javaClass.getFields();
        if (fieldArray.length > 0) {
            this._out.println("  private void createFields() {");
            this._out.println("    FieldGen field;");
            for (FieldOrMethod fieldOrMethod : fieldArray) {
                ((Field)fieldOrMethod).accept(this);
            }
            this._out.println("  }");
            this._out.println();
        }
        FieldOrMethod[] fieldOrMethodArray = javaClass.getMethods();
        for (int i = 0; i < fieldOrMethodArray.length; ++i) {
            this._out.println("  private void createMethod_" + i + "() {");
            ((Method)fieldOrMethodArray[i]).accept(this);
            this._out.println("  }");
            this._out.println();
        }
        this.printMain();
        this._out.println("}");
    }

    private void printCreate() {
        this._out.println("  public void create(OutputStream out) throws IOException {");
        Field[] fieldArray = this._clazz.getFields();
        if (fieldArray.length > 0) {
            this._out.println("    createFields();");
        }
        Method[] methodArray = this._clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this._out.println("    createMethod_" + i + "();");
        }
        this._out.println("    _cg.getJavaClass().dump(out);");
        this._out.println("  }");
        this._out.println();
    }

    private void printMain() {
        String string = this._clazz.getClassName();
        this._out.println("  public static void main(String[] args) throws Exception {");
        this._out.println("    " + string + "Creator creator = new " + string + "Creator();");
        this._out.println("    creator.create(new FileOutputStream(\"" + string + ".class\"));");
        this._out.println("  }");
    }

    @Override
    public void visitField(Field field) {
        this._out.println();
        this._out.println("    field = new FieldGen(" + BCELifier.printFlags(field.getAccessFlags()) + ", " + BCELifier.printType(field.getSignature()) + ", \"" + field.getName() + "\", _cp);");
        ConstantValue constantValue = field.getConstantValue();
        if (constantValue != null) {
            String string = constantValue.toString();
            this._out.println("    field.setInitValue(" + string + ")");
        }
        this._out.println("    _cg.addField(field.getField());");
    }

    @Override
    public void visitMethod(Method method) {
        MethodGen methodGen = new MethodGen(method, this._clazz.getClassName(), this._cp);
        this._out.println("    InstructionList il = new InstructionList();");
        this._out.println("    MethodGen method = new MethodGen(" + BCELifier.printFlags(method.getAccessFlags(), FLAGS.METHOD) + ", " + BCELifier.printType(methodGen.getReturnType()) + ", " + BCELifier.printArgumentTypes(methodGen.getArgumentTypes()) + ", new String[] { " + Utility.printArray(methodGen.getArgumentNames(), false, true) + " }, \"" + method.getName() + "\", \"" + this._clazz.getClassName() + "\", il, _cp);");
        this._out.println();
        BCELFactory bCELFactory = new BCELFactory(methodGen, this._out);
        bCELFactory.start();
        this._out.println("    method.setMaxStack();");
        this._out.println("    method.setMaxLocals();");
        this._out.println("    _cg.addMethod(method.getMethod());");
        this._out.println("    il.dispose();");
    }

    static String printFlags(int n) {
        return BCELifier.printFlags(n, FLAGS.UNKNOWN);
    }

    public static String printFlags(int n, FLAGS fLAGS) {
        if (n == 0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 1;
        while (n3 <= 16384) {
            if ((n & n3) != 0) {
                if (n3 == 32 && fLAGS == FLAGS.CLASS) {
                    stringBuilder.append(CONSTANT_PREFIX + "ACC_SUPER | ");
                } else if (n3 == 64 && fLAGS == FLAGS.METHOD) {
                    stringBuilder.append(CONSTANT_PREFIX + "ACC_BRIDGE | ");
                } else if (n3 == 128 && fLAGS == FLAGS.METHOD) {
                    stringBuilder.append(CONSTANT_PREFIX + "ACC_VARARGS | ");
                } else if (n2 < Const.ACCESS_NAMES_LENGTH) {
                    stringBuilder.append(CONSTANT_PREFIX + "ACC_").append(Const.getAccessName(n2).toUpperCase(Locale.ENGLISH)).append(" | ");
                } else {
                    stringBuilder.append(String.format(CONSTANT_PREFIX + "ACC_BIT %x | ", n3));
                }
            }
            n3 <<= 1;
            ++n2;
        }
        String string = stringBuilder.toString();
        return string.substring(0, string.length() - 3);
    }

    static String printArgumentTypes(Type[] typeArray) {
        if (typeArray.length == 0) {
            return "Type.NO_ARGS";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuilder.append(BCELifier.printType(typeArray[i]));
            if (i >= typeArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return "new Type[] { " + stringBuilder.toString() + " }";
    }

    static String printType(Type type) {
        return BCELifier.printType(type.getSignature());
    }

    static String printType(String string) {
        Type type = Type.getType(string);
        byte by = type.getType();
        if (by <= 12) {
            return "Type." + Const.getTypeName(by).toUpperCase(Locale.ENGLISH);
        }
        if (type.toString().equals("java.lang.String")) {
            return "Type.STRING";
        }
        if (type.toString().equals("java.lang.Object")) {
            return "Type.OBJECT";
        }
        if (type.toString().equals("java.lang.StringBuffer")) {
            return "Type.STRINGBUFFER";
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return "new ArrayType(" + BCELifier.printType(arrayType.getBasicType()) + ", " + arrayType.getDimensions() + ")";
        }
        return "new ObjectType(\"" + Utility.signatureToString(string, false) + "\")";
    }

    public static void _main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage: BCELifier classname");
            System.out.println("\tThe class must exist on the classpath");
            return;
        }
        JavaClass javaClass = BCELifier.getJavaClass(stringArray[0]);
        BCELifier bCELifier = new BCELifier(javaClass, System.out);
        bCELifier.start();
    }

    static JavaClass getJavaClass(String string) throws ClassNotFoundException, IOException {
        JavaClass javaClass = Repository.lookupClass(string);
        if (javaClass == null) {
            javaClass = new ClassParser(string).parse();
        }
        return javaClass;
    }

    public static enum FLAGS {
        UNKNOWN,
        CLASS,
        METHOD;

    }
}

